
CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE

	MSGFINAL TEXT := 'FOI CRIADA';
	
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_NAME= 'pdv_vd_it_concor') THEN 

		CREATE TABLE pdv_vd_it_concor (
		cd_emp int4 NOT NULL DEFAULT 0,
		cd_filial int4 NULL DEFAULT 0,
		cd_it int4 NULL DEFAULT 0,
		cd_prod int4 NOT NULL DEFAULT 0,
		cd_vd int4 NOT NULL DEFAULT 0,	 
		dt_cad date NOT NULL DEFAULT 'now'::text::date,
		cd_vend int4 NOT NULL,
		cd_concor int4 NOT NULL,
		vlr_concor numeric(9, 2) NOT NULL,
		perc_desc numeric(9, 2) NOT NULL,
		flag_consolidado int4 NULL DEFAULT 0,	

		CONSTRAINT pdv_vd_it_concor_pkey PRIMARY KEY (cd_emp, cd_filial, cd_it,cd_prod, cd_vd)							
		)
		WITH (OIDS=FALSE);
	ELSE    
		MSGFINAL := 'A TABELA JÁ EXISTE';
	END IF;

	RAISE NOTICE 'TABELA pdv_vd_it_concor %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();





